# Digital Book Library

A simple, beautiful library for your digital children's books.

## What's Included

- **index.html** - Your library homepage (browse books)
- **add-books.html** - Drag-and-drop to add new books
- **books/** - Folder where your books live
- **assets/** - Styles and scripts for the library

## Setup (One Time)

1. **Upload this folder to hosting** (Netlify is easiest - just drag the whole folder)
2. **That's it!** You have an empty library ready for books

## Adding Books

1. **Create a book** using the Book Generator (in `/generator/`)
2. **Go to your library URL** and click the "+ Add Books" button
3. **Drag your book folder** onto the page
4. **Follow the instructions** - it tells you exactly what to do
5. **Done!** Book appears in your library

Takes under 2 minutes per book. No technical skills needed.

## How It Works

### The Library Index

Books are tracked in `books/library-index.json`. It looks like:

```json
{
  "version": "1.0.0",
  "lastUpdated": "2025-10-10",
  "books": [
    {
      "id": "my-first-book",
      "title": "My First Book",
      "author": "Jane Doe",
      "category": "Adventure",
      "ageRange": "3-5",
      "description": "A wonderful story...",
      "readingTime": "5 min",
      "coverImage": "data/cover.jpg",
      "dateAdded": "2025-10-10"
    }
  ]
}
```

The "+ Add Books" page generates this for you automatically!

### File Structure

```
your-library/
├── index.html              (Library homepage)
├── add-books.html          (Add new books here)
├── manifest.json           (PWA config)
├── service-worker.js       (Offline support)
├── assets/
│   ├── css/styles.css
│   ├── js/library.js
│   └── icons/
└── books/
    ├── library-index.json  (List of all books)
    ├── book-1/
    │   ├── index.html
    │   ├── data/
    │   └── assets/
    └── book-2/
        └── ...
```

## Features

✅ **Progressive Web App (PWA)** - Install on any device like a native app
✅ **Offline Support** - Once loaded, library and books work without internet
✅ **Search** - Find books by title, author, or series
✅ **Filter** - By category and age range
✅ **Sort** - By title, author, date added, or reading time
✅ **Mobile Friendly** - Looks great on phones and tablets
✅ **Fast** - Add books in under 2 minutes

### Installing as PWA

On mobile devices, when you visit your library:
1. Look for "Add to Home Screen" prompt
2. Tap to install
3. Library appears on home screen like an app
4. Works offline after first visit!

The service worker automatically caches everything for offline use.

## Customization

### Change Library Name

Edit line 19 in `index.html`:
```html
<h1>📚 My Digital Library</h1>
```

### Change Colors

Edit the `:root` variables in `assets/css/styles.css`:
```css
:root {
    --primary-color: #2ecc71;
    --bg-color: #ecf0f1;
}
```

## Hosting

### Netlify (Recommended)
1. Go to netlify.com
2. Drag this entire folder onto their site
3. Your library is live!
4. To add books: use their web interface to upload files

### GitHub Pages
1. Create a GitHub repository
2. Upload all files
3. Enable Pages in Settings → Pages
4. Your library is at username.github.io/repo-name

### Vercel
1. Import folder to vercel.com
2. Deploy with one click

**All of these work with the "+ Add Books" page!**

## Troubleshooting

**Books not appearing?**
- Check `books/library-index.json` has the book entry
- Verify book folder name matches the `id` in library-index.json
- Hard refresh (Ctrl+Shift+R)

**Can't add books?**
- Make sure you're viewing the library through a web server (not file://)
- The "+ Add Books" page needs to run from https:// or http://

**Images not loading?**
- Check that `coverImage` path in library-index.json is correct
- Usually it's `data/cover.jpg` relative to the book folder

## Support

See the main project README for more help.

---

**Keep it simple!** This library is designed to be easy. If something feels complicated, you're probably overthinking it.
